<?php
/**
 * Autoloader
 * PSR-4 compliant autoloader for the application
 */

spl_autoload_register(function ($class) {
    $baseDirs = [
        __DIR__ . '/../core/',
        __DIR__ . '/../middleware/',
        __DIR__ . '/../controllers/',
        __DIR__ . '/../services/',
        __DIR__ . '/../repositories/',
        __DIR__ . '/../models/',
        __DIR__ . '/../utils/',
    ];
    
    foreach ($baseDirs as $baseDir) {
        $file = $baseDir . $class . '.php';
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
});
