<?php
/**
 * Environment Configuration Example
 * Copy this file to env.php and update with your actual values
 * NEVER commit env.php to version control
 */

// =============================================================================
// DATABASE CONFIGURATION
// =============================================================================
define('DB_HOST', 'localhost');
define('DB_NAME', 'billing_system');
define('DB_USER', 'billing_user');
define('DB_PASS', 'your_secure_password_here');
define('DB_CHARSET', 'utf8mb4');
define('DB_PORT', 3306);

// =============================================================================
// APPLICATION CONFIGURATION
// =============================================================================
define('APP_ENV', 'development'); // development, staging, production
define('APP_DEBUG', true);
define('APP_URL', 'http://localhost:8000');
define('API_VERSION', 'v1');
define('TIMEZONE', 'Asia/Jakarta');

// Company Information (for invoices and documents)
define('COMPANY_NAME', 'Your Company Name');
define('COMPANY_ADDRESS', 'Your Company Address');
define('COMPANY_PHONE', 'Your Company Phone');
define('COMPANY_EMAIL', 'info@yourcompany.com');

// =============================================================================
// JWT CONFIGURATION
// =============================================================================
define('JWT_SECRET', 'CHANGE_THIS_TO_256_BIT_RANDOM_KEY');
define('JWT_ALGORITHM', 'HS256');
define('JWT_EXPIRY', 3600); // 1 hour in seconds
define('JWT_REFRESH_EXPIRY', 604800); // 7 days in seconds
define('JWT_ISSUER', 'billing-system');

// =============================================================================
// SECURITY CONFIGURATION
// =============================================================================
define('PASSWORD_MIN_LENGTH', 8);
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOGIN_LOCKOUT_DURATION', 900); // 15 minutes in seconds
define('RATE_LIMIT_REQUESTS', 60); // requests per window
define('RATE_LIMIT_WINDOW', 60); // seconds
define('SESSION_LIFETIME', 86400); // 24 hours

// =============================================================================
// PAYMENT GATEWAY CONFIGURATION
// =============================================================================
// Xendit
define('XENDIT_API_KEY', 'your_xendit_api_key_here');
define('XENDIT_CALLBACK_TOKEN', 'your_xendit_callback_token_here');
define('XENDIT_PUBLIC_KEY', 'your_xendit_public_key_here');
define('XENDIT_IS_PRODUCTION', false);

// Tripay
define('TRIPAY_API_KEY', 'your_tripay_api_key_here');
define('TRIPAY_PRIVATE_KEY', 'your_tripay_private_key_here');
define('TRIPAY_MERCHANT_CODE', 'your_merchant_code_here');
define('TRIPAY_IS_PRODUCTION', false);

// =============================================================================
// FILE UPLOAD CONFIGURATION
// =============================================================================
define('MAX_UPLOAD_SIZE', 5242880); // 5MB in bytes
define('ALLOWED_FILE_TYPES', json_encode(['jpg', 'jpeg', 'png', 'pdf', 'doc', 'docx']));
define('UPLOAD_PATH', __DIR__ . '/../storage/uploads/');
define('EXPORT_PATH', __DIR__ . '/../storage/exports/');

// =============================================================================
// FIREBASE CLOUD MESSAGING
// =============================================================================
define('FCM_SERVER_KEY', 'your_fcm_server_key_here');
define('FCM_SENDER_ID', 'your_fcm_sender_id_here');

// =============================================================================
// EMAIL CONFIGURATION (Optional - for notifications)
// =============================================================================
define('MAIL_HOST', 'smtp.gmail.com');
define('MAIL_PORT', 587);
define('MAIL_USERNAME', 'your_email@gmail.com');
define('MAIL_PASSWORD', 'your_email_password');
define('MAIL_FROM_ADDRESS', 'noreply@billing.local');
define('MAIL_FROM_NAME', 'Billing System');

// =============================================================================
// LOGGING CONFIGURATION
// =============================================================================
define('LOG_PATH', __DIR__ . '/../logs/');
define('LOG_LEVEL', 'debug'); // debug, info, warning, error, critical
define('LOG_MAX_FILES', 30); // days to keep logs

// =============================================================================
// CORS CONFIGURATION
// =============================================================================
define('CORS_ALLOWED_ORIGINS', json_encode([
    'http://localhost:3000',
    'http://localhost:8080',
    APP_URL
]));
define('CORS_ALLOWED_METHODS', 'GET, POST, PUT, DELETE, OPTIONS');
define('CORS_ALLOWED_HEADERS', 'Content-Type, Authorization, X-Requested-With');
define('CORS_MAX_AGE', 86400);

// =============================================================================
// PAGINATION
// =============================================================================
define('DEFAULT_PAGE_SIZE', 20);
define('MAX_PAGE_SIZE', 100);

// =============================================================================
// Set timezone
// =============================================================================
date_default_timezone_set(TIMEZONE);

// =============================================================================
// Error reporting based on environment
// =============================================================================
if (APP_ENV === 'production') {
    error_reporting(0);
    ini_set('display_errors', 0);
} else {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
}
