<?php
/**
 * CORS Middleware
 * Handle Cross-Origin Resource Sharing
 */

class CorsMiddleware {
    public static function handle(Request $request): void {
        $origin = $request->getHeader('Origin') ?? '*';
        $allowedOrigins = json_decode(CORS_ALLOWED_ORIGINS, true);
        
        // Check if origin is allowed
        if (in_array($origin, $allowedOrigins) || in_array('*', $allowedOrigins)) {
            header("Access-Control-Allow-Origin: {$origin}");
        } else {
            header("Access-Control-Allow-Origin: {$allowedOrigins[0]}");
        }
        
        header("Access-Control-Allow-Methods: " . CORS_ALLOWED_METHODS);
        header("Access-Control-Allow-Headers: " . CORS_ALLOWED_HEADERS);
        header("Access-Control-Max-Age: " . CORS_MAX_AGE);
        header("Access-Control-Allow-Credentials: true");
        
        // Handle preflight request
        if ($request->getMethod() === 'OPTIONS') {
            http_response_code(200);
            exit;
        }
    }
}
